#--------------------------------------------------------
#	Script PiXYZ STUDIO - Generate Proxy Mesh
#
#	This Python script is meant to be used in PiXYZ STUDIO 
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	
#	This script is an APPROXIMATE version in Python of the scenario GENERATE PROXY MESH available in the SCENARIOS menu
#	See the API documentation for more information on that specific scenario, and on all the unitary algorithms used below
#	
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

GRID_RESOLUTION=50
KEEP_ORIGINAL_MESH=True
BAKE_TEXTURES=True
TEXTURE_RESOLUTION=1024
TEXTURE_PADDING=1

#Texture maps to bake
DIFFUSE=True
NORMAL=True
MATERIAL_ID=False
PART_ID=False

if scene.getPolygonCount(root) == 0:
	raise Exception('This scenario works for meshes only (requires the selected parts to be tessellated first).')

#Deletes hidden parts (visibility off)
scene.selectPartsFromNoShow()
scene.deleteOccurrences(scene.getSelectionedOccurrences())

#Gets part paths
parts = scene.getPartPaths()

#Gets the bounding box of the selection of all the parts in the scene
aabb = scene.getAABB(parts)

#Calculates the 3 lengths of the bounding box
lenX = aabb[1][0] - aabb[0][0]
lenY = aabb[1][1] - aabb[0][1]
lenZ = aabb[1][2] - aabb[0][2]

#Calculates the voxel size from maximum of the 3 lengths
voxelSize = max(lenX, lenY, lenZ) / GRID_RESOLUTION

#Creates the proxy mesh
path = algo.proxyMesh(parts, voxelSize, True)

#Transforms a path to a list of paths
proxy = [path]

#Creates normals on the generated proxy mesh, to smooth the mesh
algo.createNormals(proxy)

#Decimates the newly created proxy mesh to optimize polygon count
algo.decimate(proxy, 1, -1, 1)

if BAKE_TEXTURES:
    maps = []
    if DIFFUSE:
        maps.append(algo.MapType.Diffuse)

    if NORMAL:
        maps.append(algo.MapType.Normal)

    if MATERIAL_ID:
        maps.append(algo.MapType.MaterialId)

    if PART_ID:
        maps.append(algo.MapType.PartId)

    algo.createNormals(proxy, 180)

    algo.mapUvOnAABB(proxy, False, 100.000000, 0, True)
    algo.repackUV(proxy, 0, True, TEXTURE_RESOLUTION, TEXTURE_PADDING * 2, True)

    algo.createTangents(proxy)
    if len(maps) > 0:
        images = algo.bakeMaps(proxy, root, maps, 0, TEXTURE_RESOLUTION, TEXTURE_PADDING)
        if len(images) != len(maps):
            quit()

        diffuseMapIndex = -1
        normalMapIndex = -1
        for ind in range(0, len(maps)):
            map = maps[ind]
            if map == algo.MapType.Diffuse:
                diffuseMapIndex = ind
            elif map == algo.MapType.Normal:
                normalMapIndex = ind

        mat = material.createMaterial("Baked", "PBR")

        if diffuseMapIndex >= 0:
            core.setProperty(mat, "albedo", "TEXTURE([[1,1],[0,0],"+str(images[diffuseMapIndex])+", 0])")

        if normalMapIndex >= 0:
            normalTangent = algo.convertNormalMap(proxy, images[normalMapIndex], 0, True, False, True, False, False, TEXTURE_RESOLUTION, TEXTURE_PADDING)
            core.setProperty(mat, "normal", "TEXTURE([[1,1],[0,0],"+str(normalTangent)+", 0])")
            # for security:
            algo.orientNormalMap(normalTangent)
                                
        core.setProperty(path[-1], "Material", str(mat))

#Deletes original mesh(es) if requested
if not KEEP_ORIGINAL_MESH:
    scene.deleteOccurrences(parts)
	
